/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.storage;

import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.StorageConstants;
import oracle.ops.verification.framework.storage.StorageInfo;

public class ASMDiskGroup
extends StorageInfo
implements StorageConstants {
    private StorageSize m_size = new StorageSize(0.0, StorageUnit.BYTE);
    private StorageSize m_free = new StorageSize(0.0, StorageUnit.BYTE);
    String m_redundancy = null;
    String m_name = null;
    String m_asmsid = null;

    public ASMDiskGroup(String node) {
        super(null, node, 13);
        this.m_access = 1;
    }

    private ASMDiskGroup() {
        super(null, null, 13);
    }

    public static ASMDiskGroup parseInput(String node, String input) {
        String[] values = input.trim().split("[ ]+");
        if (values.length < 4) {
            return null;
        }
        for (int i = 0; i < values.length; ++i) {
            Trace.out((String)("Reading kfod output-values[" + i + "] =" + values[i]));
        }
        ASMDiskGroup dg = new ASMDiskGroup(node);
        block12: for (int i = 0; i < values.length; ++i) {
            switch (i) {
                case 0: {
                    try {
                        dg.m_size = new StorageSize(Double.parseDouble(values[i].trim()), StorageUnit.MBYTE);
                    }
                    catch (NumberFormatException e) {
                        dg.m_size = new StorageSize(-1.0, StorageUnit.BYTE);
                    }
                    continue block12;
                }
                case 1: {
                    try {
                        dg.m_free = new StorageSize(Double.parseDouble(values[i].trim()), StorageUnit.MBYTE);
                    }
                    catch (NumberFormatException e) {
                        dg.m_free = new StorageSize(-1.0, StorageUnit.BYTE);
                    }
                    continue block12;
                }
                case 2: {
                    dg.m_redundancy = values[i].trim();
                    continue block12;
                }
                case 3: {
                    dg.m_path = dg.m_name = values[i].trim();
                    continue block12;
                }
                case 4: {
                    dg.m_asmsid = values[i].trim();
                    continue block12;
                }
            }
        }
        return dg;
    }

    @Override
    public StorageSize getSize() {
        return this.m_size;
    }

    @Override
    public StorageSize getFree() {
        return this.m_free;
    }

    public String getRedundancyType() {
        return this.m_redundancy;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getSignature() {
        return this.m_name;
    }

    public String getASMSID() {
        return this.m_asmsid;
    }

    @Override
    public String toString() {
        return "Name:" + this.m_name + " Size:" + this.m_size + " Free:" + this.m_free + " ASMSID:" + this.m_asmsid + " RedundancyType:" + this.m_redundancy;
    }
}

